/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.harvesting;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class HarvestHandler {
    public void harvest(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        world.m_46961_(pos, true);
    }

    public boolean harvestAndReplant(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        this.harvest(world, chunkCache, pos, state, drone);
        return false;
    }

    public abstract boolean canHarvest(Level var1, BlockGetter var2, BlockPos var3, BlockState var4, IDrone var5);

    public List<ItemStack> addFilterItems(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        return world instanceof ServerLevel ? Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos)) : Collections.emptyList();
    }

    public static class SimpleHarvestHandler
    extends HarvestHandler {
        private final Set<Block> blocks;

        public SimpleHarvestHandler(Block ... blocks) {
            this.blocks = Sets.newHashSet((Object[])blocks);
        }

        @Override
        public boolean canHarvest(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
            return this.blocks.contains(state.m_60734_());
        }
    }
}

